from enum import IntEnum, IntFlag, auto


class EEFMeasurementParameter(IntEnum):
	# <summary>
	# Set the timeout for the ReadResults() command.
	# </summary>
	# <value type="uint32_t">
	# [ms]
	# </value>
	ReadResultsTimeout = 0
	# <summary>
	# Set the power of the flash lamp.
	# </summary>
	# <value type="q31_t">
	# </value>
	FlashLampPower = auto()
	# <summary>
	# Enable the high power mode of the flash lamp.
	# </summary>
	# <value type="int32_t">
	# \li\b 0 = High Speed Mode
	# \li\b 1 = High Power Mode
	# </value>
	FlashLampHighPowerEnable = auto()
	# <summary>
	# Set the power of the alpha laser.
	# </summary>
	# <value type="q31_t">
	# </value>
	AlphaLaserPower = auto()
	# <summary>
	# Enable the alpha laser power supply. This is not the excitation signal.
	# </summary>
	# <value type="int32_t">
	# \li\b 0 = Disabled
	# \li\b 1 = Enabled
	# </value>
	AlphaLaserEnable = auto()
	# <summary>
	# Set the discriminator level of PMT1.
	# </summary>
	# <value type="q31_t">
	# </value>
	PMT1DiscriminatorLevel = auto()
	# <summary>
	# Set the high voltage setting of PMT1.
	# </summary>
	# <value type="q31_t">
	# </value>
	PMT1HighVoltageSetting = auto()
	# <summary>
	# Get the high voltage monitor value of PMT1.
	# 
	# Read Only
	# </summary>
	# <value type="q31_t">
	# </value>
	PMT1HighVoltageMonitor = auto()
	# <summary>
	# Set the discriminator level of PMT2.
	# </summary>
	# <value type="q31_t">
	# </value>
	PMT2DiscriminatorLevel = auto()
	# <summary>
	# Set the high voltage setting of PMT2.
	# </summary>
	# <value type="q31_t">
	# </value>
	PMT2HighVoltageSetting = auto()
	# <summary>
	# Get the high voltage monitor value of PMT2.
	# 
	# Read Only
	# </summary>
	# <value type="q31_t">
	# </value>
	PMT2HighVoltageMonitor = auto()
	# <summary>
	# Set the discriminator level of PMT US-LUM.
	# </summary>
	# <value type="q31_t">
	# </value>
	PMTUSLUMDiscriminatorLevel = auto()
	# <summary>
	# Get the high voltage monitor value of PMT US-LUM.
	# 
	# Read Only
	# </summary>
	# <value type="q31_t">
	# </value>
	PMTUSLUMHighVoltageSetting = auto()
	# <summary>
	# PMTUSLUMHighVoltageMonitor
	# 
	# Read Only
	# </summary>
	# <value type="q31_t">
	# </value>
	PMTUSLUMHighVoltageMonitor = auto()
	# <summary>
	# Select the mover and direction for the step counter of the StepcounterWaitAndRestart sequencer instruction.
	# </summary>
	# <value type="int32_t">
	# \li\b 0 = Scan Table Y
	# \li\b 1 = Scan Table X
	# \li\b 2 = Aperture Slider 1
	# \li\b 3 = Aperture Slider 2
	# \li\b Bit7 = Movement Direction Negative
	# </value>
	StepCounterSelect = auto()
	# <summary>
	# Enable the high voltage supply of PMT1.
	# </summary>
	# <value type="int32_t">
	# \li\b 0 = High Voltage OFF
	# \li\b 1 = High Voltage ON
	# </value>
	PMT1HighVoltageEnable = auto()
	# <summary>
	# Enable the high voltage supply of PMT2.
	# </summary>
	# <value type="int32_t">
	# \li\b 0 = High Voltage OFF
	# \li\b 1 = High Voltage ON
	# </value>
	PMT2HighVoltageEnable = auto()
	# <summary>
	# Enable the high voltage supply of PMT US-LUM.
	# </summary>
	# <value type="int32_t">
	# \li\b 0 = High Voltage OFF
	# \li\b 1 = High Voltage ON
	# </value>
	PMTUSLUMHighVoltageEnable = auto()
	# <summary>
	# Set the power of the HTS alpha laser.
	# </summary>
	# <value type="q31_t">
	# </value>
	HTSAlphaLaserPower = auto()
	# <summary>
	# Enable the HTS alpha laser power supply. This is not the excitation signal.
	# </summary>
	# <value type="int32_t">
	# \li\b 0 = Disabled
	# \li\b 1 = Enabled
	# </value>
	HTSAlphaLaserEnable = auto()
	# <summary>
	# Enable or disable sending an event to the controller when the interlock status changes.
	# </summary>
	# <value type="int32_t">
	# \li\b 0 = Disabled
	# \li\b 1 = Enabled
	# </value>
	InterlockEventEnable = auto()
	# <summary>
	# Get the status of the interlock.
	# </summary>
	# <value type="uint32_t">
	# \li\b Bit0 = Output (low if output is on)
	# \li\b Bit1 = Error (low if no error detected)
	# \li\b Bit2 = Filter Door Sensor (low if filter door closed)
	# \li\b Bit3 = Dispenser Sensor (low if dispenser closed)
	# </value>
	InterlockStatus = auto()
	# <summary>
	# Enable or disable sending an event to the controller when the error event status changes.
	# </summary>
	# <value type="int32_t">
	# \li\b 0 = Disabled
	# \li\b 1 = Enabled
	# </value>
	ErrorEventEnable = auto()
	# <summary>
	# Get the status of the error events.
	# </summary>
	# <value type="uint32_t">
	# \li\b Bit0 = Alpha Laser Temperature Error
	# \li\b Bit1 = HTS Alpha Laser Temperature Error
	# </value>
	ErrorEventStatus = auto()


EEFMEASUREMENTPARAMETER_TYPE = {EEFMeasurementParameter.ReadResultsTimeout:"L", EEFMeasurementParameter.FlashLampPower:"lq", EEFMeasurementParameter.FlashLampHighPowerEnable:"l", EEFMeasurementParameter.AlphaLaserPower:"lq", EEFMeasurementParameter.AlphaLaserEnable:"l", EEFMeasurementParameter.PMT1DiscriminatorLevel:"lq", EEFMeasurementParameter.PMT1HighVoltageSetting:"lq", EEFMeasurementParameter.PMT1HighVoltageMonitor:"lq", EEFMeasurementParameter.PMT2DiscriminatorLevel:"lq", EEFMeasurementParameter.PMT2HighVoltageSetting:"lq", EEFMeasurementParameter.PMT2HighVoltageMonitor:"lq", EEFMeasurementParameter.PMTUSLUMDiscriminatorLevel:"lq", EEFMeasurementParameter.PMTUSLUMHighVoltageSetting:"lq", EEFMeasurementParameter.PMTUSLUMHighVoltageMonitor:"lq", EEFMeasurementParameter.StepCounterSelect:"l", EEFMeasurementParameter.PMT1HighVoltageEnable:"l", EEFMeasurementParameter.PMT2HighVoltageEnable:"l", EEFMeasurementParameter.PMTUSLUMHighVoltageEnable:"l", EEFMeasurementParameter.HTSAlphaLaserPower:"lq", EEFMeasurementParameter.HTSAlphaLaserEnable:"l", EEFMeasurementParameter.InterlockEventEnable:"l", EEFMeasurementParameter.InterlockStatus:"L", EEFMeasurementParameter.ErrorEventEnable:"l", EEFMeasurementParameter.ErrorEventStatus:"L"}

